% The generalized extreme value distribution.
function h = PDFGEV(r,params)
sigma = params(1); %scale 
xi = params(2); %1/xi is the shape
mu = params(3); % center
z = max(000000000001, 1+xi*(r-mu)/sigma);
z = 1+xi*(r-mu)/sigma;
h = z.^(-(1+1/xi)).*exp(-z.^(-1/xi))/sigma;
